SuperStrength = {}
SuperStrength.modName = g_currentModName
SuperStrength.modDirectory = g_currentModDirectory
SuperStrength.isMultiplayer = false
SuperStrength.active = false

function SuperStrength.initSpecialization()
	SuperStrength.isMultiplayer = g_careerScreen.isMultiplayer
	source(SuperStrength.modDirectory .. 'src/SuperStrengthEvent.lua')
end

function SuperStrength.prerequisitesPresent(specializations)
	return true
end

function SuperStrength.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "toggleSuperStrength", SuperStrength.toggleStrength)
end

function SuperStrength.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", SuperStrength)
end

function SuperStrength:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	if BaseMission:getIsClient() then
		local result, actionEventId = g_inputBinding:registerActionEvent(InputAction.TOGGLE_SUPER_STRENGTH, self, SuperStrength.toggleStrength, false, true, false, true, nil, true)
		g_inputBinding:setActionEventText(actionEventId, g_i18n:getText("menu_TOGGLE_SUPER_STRENGTH"))
		g_inputBinding:setActionEventTextVisibility(actionEventId, true)
		g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW)
		g_inputBinding:setActionEventActive(actionEventId, true)
	end
end

function SuperStrength:toggleStrength()
	local player = g_currentMission.playerSystem:getPlayerByUserId(g_currentMission.playerUserId)
	local playerUniqueId = player.uniqueUserId
	if player ~= nil then
		SuperStrength.active = Utils.getNoNil(player.hands.spec_hands.hasSuperStrength, false)
	end
	local superStrengthActive = Utils.getNoNil(SuperStrength.active, false)

	if SuperStrength.isMultiplayer then
		if self.isServer then
			local userId = g_currentMission.playerUserId
			g_server:broadcastEvent(SuperStrengthEvent.new(superStrengthActive, playerUniqueId))
		else
			g_client:getServerConnection():sendEvent(SuperStrengthEvent.new(not superStrengthActive, playerUniqueId))
			player.hands:consoleCommandToggleSuperStrength()
			SuperStrength.active = player.hands.spec_hands.hasSuperStrength
		end
	else
		player.hands:consoleCommandToggleSuperStrength()
		SuperStrength.active = player.hands.spec_hands.hasSuperStrength
	end
end

function SuperStrength:keyEvent(unicode, sym, modifier, isDown)
    if bitAND(modifier, Input.MOD_LALT) > 0 and Input.isKeyPressed(Input.KEY_k) then
		SuperStrength:toggleStrength()
    end
end

addModEventListener(SuperStrength)
